cd `dirname $0`

if test -d /opt/$VENDOR/PSU ; then
	DEST_PATH="/opt/$VENDOR/PSU/"
elif test -d /opt/$VENDOR/psu ; then
	DEST_PATH="/opt/$VENDOR/psu/"
else
	echo "INFO: psu already uninstalled."
	return
fi

# Start PhoneBook uninstall if found
if test -e ../phonebook/uninstall.sh ; then
	sh ../phonebook/uninstall.sh $VENDOR
elif test -e ../PhoneBook/uninstall.sh ; then
	sh ../PhoneBook/uninstall.sh $VENDOR
fi

# Start EmailBook uninstall if found
if test -e ../emailbook/uninstall.sh ; then
	sh ../emailbook/uninstall.sh $VENDOR
elif test -e ../EmailBook/uninstall.sh ; then
	sh ../EmailBook/uninstall.sh $VENDOR
fi

# Start PSULauncher uninstall if found
if test -e ../psulauncher/uninstall.sh ; then
	sh ../psulauncher/uninstall.sh $VENDOR
elif test -e ../PSULauncher/uninstall.sh ; then
	sh ../PSULauncher/uninstall.sh $VENDOR
fi

#remove destination
VERSION=`cat "$DEST_PATH""bin/.version"`
rm -fr "$DEST_PATH"
if test -d "$DEST_PATH" ; then
	echo "ERROR: Cannot uninstall psu! Check your permissions."
	return
else
	echo "INFO: psu (ver.$VERSION) has been uninstalled successfully"
fi

# remove folder if it is empty
if [ -z "`ls -A /opt/$VENDOR/`" ]
then
	rm -fr /opt/$VENDOR/
fi	
