#!/bin/sh

VENDOR=$1

BASE_DIR=`dirname "$0"`
cd "$BASE_DIR"

HARDWARE_PLATFORM=`uname -m`
if [ "$HARDWARE_PLATFORM" = "i486" -o "$HARDWARE_PLATFORM" = "i586" -o "$HARDWARE_PLATFORM" = "i686" ]
then
	PLSFX=
	HARDWARE_PLATFORM=i386
fi

if [ "$HARDWARE_PLATFORM" = "x86_64" ]
then
	PLSFX=64
fi

APP_NAME=`basename "$BASE_DIR" | tr A-Z a-z`
case $APP_NAME in
	phonebook) DEST_DIRNAME=PhoneBook ;;
	emailbook) DEST_DIRNAME=EmailBook ;;
	addressbook) DEST_DIRNAME=AddressBook ;;
	wirelesssetup) DEST_DIRNAME=WirelessSetup ;;
	*) echo "ERROR: Invalid application <$APP_NAME>."; return ;;
esac

DEST_PATH=/opt/$VENDOR/$DEST_DIRNAME

#recreate destination
rm -fr "$DEST_PATH"
mkdir -p "$DEST_PATH"

#install distributive
#x echo "Installing..."

if [ "$PLSFX" = "64" ]; then
	mkdir -p "$DEST_PATH/bin"
	cp -fr ./bin64/* "$DEST_PATH/bin"
	cp -fr ./bin64/.version "$DEST_PATH/bin"
else	
	cp -fr ./bin/ "$DEST_PATH"
fi

if [ $? -ne 0 ]
then
	echo "ERROR: Cannot copy binaries! Check your permissions."
	return
fi

cp -fr ./share/ "$DEST_PATH"
if [ $? -ne 0 ]
then
	echo "ERROR: Cannot copy data! Check your permissions."
	return
fi

#copy uninstall script
cp -f ./uninstall.sh "$DEST_PATH"

#change attributes
chown root "$DEST_PATH/bin/$APP_NAME"
chmod 4755 "$DEST_PATH/bin/$APP_NAME"

VERSION=`cat "$DEST_PATH/bin/.version"`
echo "INFO: $APP_NAME (ver.$VERSION) has been installed successfully in $DEST_PATH"
