#!/bin/sh
VENDOR=Samsung

BASE_DIR=`dirname "$0"`
cd "$BASE_DIR"

# check_libstdcxx procedure from Unified Linux Driver project. Modified.

HARDWARE_PLATFORM=`uname -m`
if [ "$HARDWARE_PLATFORM" = "i486" -o "$HARDWARE_PLATFORM" = "i586" -o "$HARDWARE_PLATFORM" = "i686" ]
then
	PLSFX=
	HARDWARE_PLATFORM=i386
fi

if [ "$HARDWARE_PLATFORM" = "x86_64" ]
then
	PLSFX=64
fi

check_libstdcxx() {
	if [ "$PLSFX" != "64" ]; then
		LIBSTDCXX_FILES=`ls /usr/lib${PLSFX}/libstdc++.so.5* 2> /dev/null`
		LIBSTDCXX_ARC="share/libstdc++-5-${HARDWARE_PLATFORM}.tar.gz"
		if test -z "$LIBSTDCXX_FILES" -a -f $LIBSTDCXX_ARC ; then
			echo -n "libstdc++.so.5 (gcc 3.0.x .. 3.3.x) not found, intstall ... "
			zcat $LIBSTDCXX_ARC | tar -xf - -C /
			ldconfig
			echo "done"
		fi
	fi
}

check_libstdcxx

DEST_PATH="/opt/$VENDOR/PSU"

#recreate destination
rm -fr "$DEST_PATH"
mkdir -p "$DEST_PATH"
mkdir -p "$DEST_PATH/share"

if [ $? -ne 0 ]
then
	echo "ERROR: Cannot copy binaries! Check your permissions."
	return
fi

( tar -cf - . | tar -xf - -C $DEST_PATH 2> /dev/null )

if [ "$PLSFX" = "64" ]; then
	rm -rf "$DEST_PATH/bin"
	mv "$DEST_PATH/bin64" "$DEST_PATH/bin"
fi

mkdir -p $DEST_PATH/share/translation
rm -rf $DEST_PATH/install.sh $DEST_PATH/bin64 $DEST_PATH/share/libstdc*
ls -d $DEST_PATH/share/?? 2>/dev/null &&
mv $DEST_PATH/share/?? $DEST_PATH/share/translation/

#copy uninstall script
cp -f ./uninstall.sh "$DEST_PATH"

#change ownerships
find "$DEST_PATH" -exec chown -h root:root \{\} \;


#change attributes
chown root "$DEST_PATH/bin/psu"
chmod 4755 "$DEST_PATH/bin/psu"

VERSION=`cat "$DEST_PATH/bin/.version"`
echo "INFO: psu (ver.$VERSION) has been installed successfully in $DEST_PATH"

# Start Phonebook install if found
if test -e ../phonebook/install.sh ; then
	sh ../phonebook/install.sh $VENDOR
fi

# Start Emailbook install if found
if test -e ../emailbook/install.sh ; then
	sh ../emailbook/install.sh $VENDOR
fi

# Start Addressbook install if found
if test -e ../addressbook/install.sh ; then
	sh ../addressbook/install.sh $VENDOR
fi

# Start WirelessSetup install if found
if test -e ../wirelesssetup/install.sh ; then
	sh ../wirelesssetup/install.sh $VENDOR
fi

# Start psulauncher install if found
if test -e ../psulauncher/install.sh ; then
	sh ../psulauncher/install.sh
fi
