/*
 * Decompiled with CFR 0.152.
 */
package Util;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class MACTextField
extends JTextField
implements KeyListener {
    private int maxLength;

    public MACTextField(String string, int n, int n2) {
        super(string, n);
        this.maxLength = n2;
        this.addKeyListener(this);
    }

    public MACTextField(int n, int n2) {
        this("", n, n2);
    }

    protected Document createDefaultModel() {
        return new UpperCaseDocument();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c != '\b' && c != '\u007f' || c == '\n' || c == '\t' || keyEvent.isActionKey()) {
            if (((JTextField)keyEvent.getSource()).getText().length() >= this.maxLength) {
                if (this.getSelectedText() == null) {
                    keyEvent.consume();
                } else if (!this.checkHex(c)) {
                    keyEvent.consume();
                }
            } else if (!this.checkHex(c)) {
                keyEvent.consume();
            }
        }
    }

    private boolean checkHex(char c) {
        try {
            Integer.parseInt(String.valueOf(c));
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            String string = String.valueOf(c);
            String string2 = string.toUpperCase();
            char[] cArray = string2.toCharArray();
            c = cArray[0];
            return c == 'A' || c == 'B' || c == 'C' || c == 'D' || c == 'E' || c == 'F';
        }
    }

    static class UpperCaseDocument
    extends PlainDocument {
        UpperCaseDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = Character.toUpperCase(cArray[i]);
            }
            super.insertString(n, new String(cArray), attributeSet);
        }
    }
}

