/*
 * Decompiled with CFR 0.152.
 */
package Function;

import Util.Log;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;

public class ManageSocket {
    MulticastSocket socket;
    static int SetIP_Dest_Port = 6000;

    public boolean CreateSocket() {
        try {
            this.socket = new MulticastSocket();
            Log.write(0, "LocalPort is " + this.socket.getLocalPort());
            Log.write(0, "InetAddress is " + this.socket.getLocalAddress().getHostAddress());
            this.socket.setSoTimeout(2);
        }
        catch (Exception exception) {
            Log.write(3, "cannot create datagram socket");
            return false;
        }
        return true;
    }

    public boolean CreateSocket(int n, InetAddress inetAddress) {
        try {
            this.socket = new MulticastSocket(n);
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(inetAddress);
            Log.write(0, "LocalPort is " + this.socket.getLocalPort());
            Log.write(0, "InetAddress is " + this.socket.getLocalAddress().getHostAddress());
            this.socket.setSoTimeout(2);
        }
        catch (Exception exception) {
            Log.write(3, "cannot create datagram socket");
            return false;
        }
        return true;
    }

    public boolean SendSocket(byte[] byArray, int n) {
        String string = "255.255.255.255";
        try {
            DatagramPacket datagramPacket = new DatagramPacket(byArray, n, InetAddress.getByName(string), SetIP_Dest_Port);
            this.socket.send(datagramPacket);
        }
        catch (Exception exception) {
            Log.write(0, exception.getMessage());
            Log.write(0, "Sendsocket error");
            return false;
        }
        return true;
    }

    public boolean ReceiveNext(byte[] byArray, int n) {
        try {
            DatagramPacket datagramPacket = new DatagramPacket(byArray, n);
            this.socket.receive(datagramPacket);
        }
        catch (Exception exception) {
            Log.write(0, exception.getMessage());
            return false;
        }
        return true;
    }

    public void Close() {
        Log.write(0, "Close");
        this.socket.close();
        this.socket.disconnect();
    }

    public void setTimeout(int n) {
        try {
            this.socket.setSoTimeout(n);
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
        }
    }

    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }
}

