/*
 * Decompiled with CFR 0.152.
 */
package UI;

import Function.MainModel;
import UI.ConfirmDialog;
import Util.IPTextBox;
import Util.ImageButton;
import Util.Log;
import Util.MACTextField;
import Util.WebAppRes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EtchedBorder;

public class ConfigDialog
extends JDialog
implements MouseListener {
    private JLabel Label1;
    private JLabel Label2;
    private JLabel Label3;
    private JLabel Label4;
    private JLabel Label5;
    private JLabel Label6;
    private ImageButton btnApp;
    private ImageButton btnCanc;
    private ImageButton btnReset;
    private IPTextBox ip;
    private IPTextBox subnet;
    private IPTextBox gate;
    private MACTextField mac;
    private MACTextField pName;
    private MACTextField mName;
    private String[] oData;
    private MainModel model;
    private static final String app = " : ";
    private ConfirmDialog dlg;

    public ConfigDialog(Frame frame, String string, boolean bl, MainModel mainModel, boolean bl2) {
        super(frame, string, bl);
        this.setSize(514, 414);
        this.setResizable(false);
        this.getRootPane().setLayout(new BorderLayout());
        JPanel jPanel = !bl2 ? this.init() : this.init2();
        this.getRootPane().add((Component)jPanel, "Center");
        this.model = mainModel;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ConfigDialog.this.hide();
            }
        });
    }

    public JPanel init() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(new Color(231, 231, 231));
        jPanel.setLayout(null);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setBackground(new Color(231, 231, 231));
        jPanel.add(jTabbedPane);
        jTabbedPane.reshape(5, 2, 495, 347);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(null);
        jPanel2.setBackground(new Color(231, 231, 231));
        jTabbedPane.addTab("TCP / IP", null, jPanel2, null);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(null);
        jPanel3.setBorder(new EtchedBorder(1));
        jPanel3.setBackground(new Color(231, 231, 231));
        jPanel2.add(jPanel3);
        jPanel3.reshape(20, 20, 450, 270);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(null);
        jPanel4.setBorder(new EtchedBorder(1));
        jPanel4.setBackground(new Color(231, 231, 231));
        jPanel3.add(jPanel4);
        jPanel4.reshape(14, 87, 420, 152);
        this.Label1 = new JLabel(WebAppRes.GetString("IDS_MAC_ADDR") + app, 2);
        this.Label1.setFont(new Font(null, 0, 13));
        this.Label2 = new JLabel(WebAppRes.GetString("IDS_IP_ADDR") + app, 2);
        this.Label2.setFont(new Font(null, 0, 13));
        this.Label3 = new JLabel(WebAppRes.GetString("IDS_SUBNET_ADDR") + app, 2);
        this.Label3.setFont(new Font(null, 0, 13));
        this.Label4 = new JLabel(WebAppRes.GetString("IDS_GATEWAY_ADDR") + app, 2);
        this.Label4.setFont(new Font(null, 0, 13));
        jPanel3.add(this.Label1);
        this.Label1.reshape(35, 30, 150, 25);
        this.mac = new MACTextField(12, 12);
        this.mac.setHorizontalAlignment(0);
        this.mac.setBorder(BorderFactory.createLoweredBevelBorder());
        this.mac.setFont(new Font(null, 0, 13));
        jPanel3.add(this.mac);
        this.mac.reshape(222, 30, 176, 22);
        jPanel4.add(this.Label2);
        jPanel4.add(this.Label3);
        jPanel4.add(this.Label4);
        this.Label2.reshape(21, 17, 150, 25);
        this.Label3.reshape(21, 62, 150, 25);
        this.Label4.reshape(21, 107, 150, 25);
        this.ip = this.createIPText();
        JPanel jPanel5 = this.wrapIPText(this.ip);
        this.subnet = this.createIPText();
        JPanel jPanel6 = this.wrapIPText(this.subnet);
        this.gate = this.createIPText();
        JPanel jPanel7 = this.wrapIPText(this.gate);
        jPanel4.add(jPanel5);
        jPanel4.add(jPanel6);
        jPanel4.add(jPanel7);
        jPanel5.reshape(210, 17, 176, 22);
        jPanel6.reshape(210, 62, 176, 22);
        jPanel7.reshape(210, 107, 176, 22);
        this.btnApp = new ImageButton("button_short.jpg", "button_short_down.jpg", WebAppRes.GetString("IDS_APPLY"));
        this.btnCanc = new ImageButton("button_short.jpg", "button_short_down.jpg", WebAppRes.GetString("IDS_CANCEL"));
        this.btnReset = new ImageButton("button_short.jpg", "button_short_down.jpg", WebAppRes.GetString("IDS_RESET"));
        this.btnApp.setName("Apply");
        this.btnCanc.setName("Cancel");
        this.btnReset.setName("Reset");
        this.btnApp.addMouseListener(this);
        this.btnCanc.addMouseListener(this);
        this.btnReset.addMouseListener(this);
        jPanel.add(this.btnApp);
        jPanel.add(this.btnCanc);
        jPanel.add(this.btnReset);
        this.btnApp.reshape(125, 353, this.btnApp.getImageWidth(), this.btnApp.getImageHeight());
        this.btnCanc.reshape(215, 353, this.btnApp.getImageWidth(), this.btnApp.getImageHeight());
        this.btnReset.reshape(306, 353, this.btnApp.getImageWidth(), this.btnApp.getImageHeight());
        jTabbedPane.setSelectedIndex(0);
        return jPanel;
    }

    public JPanel init2() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(new Color(231, 231, 231));
        jPanel.setLayout(null);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setBackground(new Color(231, 231, 231));
        jPanel.add(jTabbedPane);
        jTabbedPane.reshape(5, 2, 495, 347);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(null);
        jPanel2.setBackground(new Color(231, 231, 231));
        jTabbedPane.addTab("TCP / IP", null, jPanel2, null);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(null);
        jPanel3.setBorder(new EtchedBorder(1));
        jPanel3.setBackground(new Color(231, 231, 231));
        jPanel2.add(jPanel3);
        jPanel3.reshape(20, 20, 450, 280);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(null);
        jPanel4.setBorder(new EtchedBorder(1));
        jPanel4.setBackground(new Color(231, 231, 231));
        jPanel3.add(jPanel4);
        jPanel4.reshape(14, 122, 420, 145);
        this.Label1 = new JLabel(WebAppRes.GetString("IDS_MODELNAME_ADDR") + app, 2);
        this.Label1.setFont(new Font(null, 0, 13));
        this.Label5 = new JLabel(WebAppRes.GetString("IDS_PRINTER_NAME") + app, 2);
        this.Label5.setFont(new Font(null, 0, 13));
        this.Label6 = new JLabel(WebAppRes.GetString("IDS_MAC_ADDR") + app, 2);
        this.Label6.setFont(new Font(null, 0, 13));
        this.Label2 = new JLabel(WebAppRes.GetString("IDS_IP_ADDR") + app, 2);
        this.Label2.setFont(new Font(null, 0, 13));
        this.Label3 = new JLabel(WebAppRes.GetString("IDS_SUBNET_ADDR") + app, 2);
        this.Label3.setFont(new Font(null, 0, 13));
        this.Label4 = new JLabel(WebAppRes.GetString("IDS_GATEWAY_ADDR") + app, 2);
        this.Label4.setFont(new Font(null, 0, 13));
        jPanel3.add(this.Label1);
        jPanel3.add(this.Label5);
        jPanel3.add(this.Label6);
        this.Label1.reshape(35, 15, 150, 25);
        this.Label5.reshape(35, 50, 150, 25);
        this.Label6.reshape(35, 85, 150, 25);
        this.mName = new MACTextField(12, 12);
        this.mName.setHorizontalAlignment(0);
        this.mName.setBorder(BorderFactory.createLoweredBevelBorder());
        this.mName.setFont(new Font(null, 0, 11));
        this.pName = new MACTextField(12, 12);
        this.pName.setHorizontalAlignment(0);
        this.pName.setBorder(BorderFactory.createLoweredBevelBorder());
        this.pName.setFont(new Font(null, 0, 11));
        this.mName.setEnabled(false);
        this.pName.setEnabled(false);
        this.mac = new MACTextField(12, 12);
        this.mac.setHorizontalAlignment(0);
        this.mac.setBorder(BorderFactory.createLoweredBevelBorder());
        this.mac.setFont(new Font(null, 0, 11));
        jPanel3.add(this.mName);
        jPanel3.add(this.pName);
        jPanel3.add(this.mac);
        this.mName.reshape(222, 15, 176, 22);
        this.pName.reshape(222, 50, 176, 22);
        this.mac.reshape(222, 85, 176, 22);
        jPanel4.add(this.Label2);
        jPanel4.add(this.Label3);
        jPanel4.add(this.Label4);
        this.Label2.reshape(21, 19, 150, 25);
        this.Label3.reshape(21, 60, 150, 25);
        this.Label4.reshape(21, 101, 150, 25);
        this.ip = this.createIPText();
        JPanel jPanel5 = this.wrapIPText(this.ip);
        this.subnet = this.createIPText();
        JPanel jPanel6 = this.wrapIPText(this.subnet);
        this.gate = this.createIPText();
        JPanel jPanel7 = this.wrapIPText(this.gate);
        jPanel4.add(jPanel5);
        jPanel4.add(jPanel6);
        jPanel4.add(jPanel7);
        jPanel5.reshape(210, 19, 176, 22);
        jPanel6.reshape(210, 60, 176, 22);
        jPanel7.reshape(210, 101, 176, 22);
        this.btnApp = new ImageButton("button_short.jpg", "button_short_down.jpg", WebAppRes.GetString("IDS_APPLY"));
        this.btnCanc = new ImageButton("button_short.jpg", "button_short_down.jpg", WebAppRes.GetString("IDS_CANCEL"));
        this.btnReset = new ImageButton("button_short.jpg", "button_short_down.jpg", WebAppRes.GetString("IDS_RESET"));
        this.btnApp.setName("Apply");
        this.btnCanc.setName("Cancel");
        this.btnReset.setName("Reset");
        this.btnApp.addMouseListener(this);
        this.btnCanc.addMouseListener(this);
        this.btnReset.addMouseListener(this);
        jPanel.add(this.btnApp);
        jPanel.add(this.btnCanc);
        jPanel.add(this.btnReset);
        this.btnApp.reshape(125, 353, this.btnApp.getImageWidth(), this.btnApp.getImageHeight());
        this.btnCanc.reshape(215, 353, this.btnApp.getImageWidth(), this.btnApp.getImageHeight());
        this.btnReset.reshape(306, 353, this.btnApp.getImageWidth(), this.btnApp.getImageHeight());
        jTabbedPane.setSelectedIndex(0);
        return jPanel;
    }

    public IPTextBox createIPText() {
        IPTextBox iPTextBox = new IPTextBox();
        iPTextBox.setBackground(new Color(255, 255, 255));
        iPTextBox.setTextBoxFont(new Font(null, 0, 13));
        iPTextBox.setSize(176, 20);
        return iPTextBox;
    }

    public JPanel wrapIPText(IPTextBox iPTextBox) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel.add((Component)iPTextBox, "Center");
        return jPanel;
    }

    public void InitialPositionSet(int n) {
    }

    public void setData(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            Log.write(0, stringArray[i]);
        }
        this.oData = stringArray;
        this.mName.setText(stringArray[0]);
        this.pName.setText(stringArray[1]);
        this.mac.setText(stringArray[2]);
        this.ip.setValue(stringArray[3].split("\\."));
        this.subnet.setValue(stringArray[4].split("\\."));
        this.gate.setValue(stringArray[5].split("\\."));
    }

    public String[] getData() {
        return new String[]{this.ip.getText(), this.subnet.getText(), this.gate.getText()};
    }

    public void setEnableMac(boolean bl) {
        this.mac.setEnabled(bl);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        Log.write(0, "Object = " + object.toString());
        if (object instanceof Panel || object instanceof ImageButton) {
            Component component = (Component)object;
            String string = component.getName();
            if (string.startsWith("Apply")) {
                if (!this.ClickApply()) {
                    return;
                }
                this.loadSetWindow();
                if (this.dlg.bOK && this.model.setIP(this.mac.getText(), this.ip, this.subnet, this.gate)) {
                    this.hide();
                    this.model.getPacket();
                }
            } else if (string.compareTo("Cancel") == 0) {
                this.hide();
            } else if (string.compareTo("Reset") == 0) {
                if (this.oData != null) {
                    this.mName.setText(this.oData[0]);
                    this.pName.setText(this.oData[1]);
                    this.mac.setText(this.oData[2]);
                    this.ip.setValue(this.oData[3].split("\\."));
                    this.subnet.setValue(this.oData[4].split("\\."));
                    this.gate.setValue(this.oData[5].split("\\."));
                } else {
                    this.mac.setText("");
                    this.ip.setValue(new String[]{"", "", "", ""});
                    this.subnet.setValue(new String[]{"", "", "", ""});
                    this.gate.setValue(new String[]{"", "", "", ""});
                }
            }
        }
    }

    public void loadSetWindow() {
        this.dlg = new ConfirmDialog(JOptionPane.getFrameForComponent(this), WebAppRes.GetString("IDS_CONFIRM_TITLE"), true, this.getData());
        this.dlg.setSize(357, 273);
        this.dlg = (ConfirmDialog)this.model.setDialogPos(WebAppRes.getCurBrowser(), this.dlg);
        this.dlg.show();
    }

    private boolean ClickApply() {
        if (this.mac.isEnabled() && this.mac.getText().length() != 12) {
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(this), WebAppRes.GetString("IDS_MAC_ERR"), WebAppRes.GetString("IDS_MAC_ERR_TITLE"), 2);
            return false;
        }
        String[] stringArray = this.model.checkIPvalue(this.ip.getValue());
        this.ip.setValue(stringArray);
        String[] stringArray2 = this.model.checkIPvalue(this.subnet.getValue());
        this.subnet.setValue(stringArray2);
        String[] stringArray3 = this.model.checkIPvalue(this.gate.getValue());
        this.gate.setValue(stringArray3);
        if (!this.model.checkIP(this.ip.getValue(), this.subnet.getValue(), this.gate.getValue())) {
            Log.write(0, "Invalid");
            return false;
        }
        Log.write(0, String.valueOf(this.model.pos));
        Log.write(0, "valid");
        return true;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

