/*
 * Decompiled with CFR 0.152.
 */
package Util;

import Util.Log;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class IPTextBox
extends JPanel
implements FocusListener {
    JTextField tBox1;
    JTextField tBox2;
    JTextField tBox3;
    JTextField tBox4;
    JLabel label1;
    JLabel label2;
    JLabel label3;
    Action nextFocusAction = null;

    public IPTextBox() {
        this.CreateTextBox();
        this.CreateLabel();
        this.setLayout(null);
        this.setBackground(new Color(255, 255, 255));
        this.add(this.tBox1);
        this.add(this.tBox2);
        this.add(this.tBox3);
        this.add(this.tBox4);
        this.add(this.label1);
        this.add(this.label2);
        this.add(this.label3);
        this.AttachEvent();
        this.ReshapeControl();
    }

    private void CreateTextBox() {
        this.tBox1 = new JTextField(5);
        this.tBox1.setBorder(null);
        this.tBox1.setHorizontalAlignment(0);
        this.tBox2 = new JTextField(5);
        this.tBox2.setBorder(null);
        this.tBox2.setHorizontalAlignment(0);
        this.tBox3 = new JTextField(5);
        this.tBox3.setBorder(null);
        this.tBox3.setHorizontalAlignment(0);
        this.tBox4 = new JTextField(5);
        this.tBox4.setBorder(null);
        this.tBox4.setHorizontalAlignment(0);
    }

    private void CreateLabel() {
        this.label1 = new JLabel(".", 0);
        this.label1.setBackground(new Color(255, 255, 255));
        this.label1.setBorder(null);
        this.label2 = new JLabel(".", 0);
        this.label2.setBackground(new Color(255, 255, 255));
        this.label2.setBorder(null);
        this.label3 = new JLabel(".", 0);
        this.label3.setBackground(new Color(255, 255, 255));
        this.label3.setBorder(null);
    }

    private void ReshapeControl() {
        int n = 30;
        int n2 = 14;
        int n3 = 20;
        int n4 = 7;
        this.tBox1.reshape(n4, 0, n, n3);
        this.label1.reshape(n4 + n, 0, n2, n3);
        this.tBox2.reshape(n4 + n + n2, 0, n, n3);
        this.label2.reshape(n4 + 2 * n + n2, 0, n2, n3);
        this.tBox3.reshape(n4 + 2 * n + 2 * n2, 0, n, n3);
        this.label3.reshape(n4 + 3 * n + 2 * n2, 0, n2, n3);
        this.tBox4.reshape(n4 + 3 * n + 3 * n2, 0, n, n3);
    }

    private void AttachEvent() {
        IntegerDocument integerDocument = new IntegerDocument();
        IntegerDocument integerDocument2 = new IntegerDocument();
        IntegerDocument integerDocument3 = new IntegerDocument();
        IntegerDocument integerDocument4 = new IntegerDocument();
        this.tBox1.setDocument(integerDocument);
        this.tBox2.setDocument(integerDocument2);
        this.tBox3.setDocument(integerDocument3);
        this.tBox4.setDocument(integerDocument4);
        this.tBox1.addKeyListener(new KeyListener(this.tBox1));
        this.tBox2.addKeyListener(new KeyListener(this.tBox2));
        this.tBox3.addKeyListener(new KeyListener(this.tBox3));
        this.tBox4.addKeyListener(new KeyListener(this.tBox4));
        this.tBox1.addFocusListener(this);
        this.tBox2.addFocusListener(this);
        this.tBox3.addFocusListener(this);
        this.tBox4.addFocusListener(this);
    }

    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        JTextField jTextField = (JTextField)object;
        jTextField.selectAll();
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public String[] getValue() {
        return new String[]{this.tBox1.getText(), this.tBox2.getText(), this.tBox3.getText(), this.tBox4.getText()};
    }

    public String getText() {
        return new String(this.tBox1.getText() + "." + this.tBox2.getText() + "." + this.tBox3.getText() + "." + this.tBox4.getText());
    }

    public void setValue(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            Log.write(0, stringArray[i]);
        }
        if (stringArray.length >= 4) {
            this.tBox1.setText(stringArray[0]);
            this.tBox2.setText(stringArray[1]);
            this.tBox3.setText(stringArray[2]);
            this.tBox4.setText(stringArray[3]);
        }
    }

    public void setTextBoxFont(Font font) {
        if (font != null) {
            this.tBox1.setFont(font);
            this.tBox2.setFont(font);
            this.tBox3.setFont(font);
            this.tBox4.setFont(font);
        }
    }

    class IntegerDocument
    extends PlainDocument {
        int currentValue = 0;

        public int getValue() {
            return this.currentValue;
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            String string2;
            if (string == null) {
                return;
            }
            int n2 = this.getLength();
            if (n2 == 0) {
                string2 = string;
            } else {
                String string3 = this.getText(0, n2);
                StringBuffer stringBuffer = new StringBuffer(string3);
                stringBuffer.insert(n, string);
                string2 = stringBuffer.toString();
            }
            this.currentValue = this.checkInput(string2, n);
            super.insertString(n, string, attributeSet);
        }

        public void remove(int n, int n2) throws BadLocationException {
            int n3 = this.getLength();
            String string = this.getText(0, n3);
            String string2 = string.substring(0, n);
            String string3 = string.substring(n2 + n, n3);
            String string4 = string2 + string3;
            this.currentValue = this.checkInput(string4, n);
            super.remove(n, n2);
        }

        public int checkInput(String string, int n) throws BadLocationException {
            if (string.length() > 0) {
                try {
                    int n2 = Integer.parseInt(string);
                    return n2;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new BadLocationException(string, n);
                }
            }
            return 0;
        }
    }

    class KeyListener
    extends KeyAdapter {
        public JTextField m_TextField;
        private int maxLength = 3;

        public KeyListener(JTextField jTextField) {
            this.m_TextField = jTextField;
        }

        public void keyReleased(KeyEvent keyEvent) {
            boolean bl = false;
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 46: 
                case 110: {
                    this.m_TextField.nextFocus();
                    break;
                }
                case 39: {
                    this.m_TextField.nextFocus();
                    break;
                }
                default: {
                    if (this.m_TextField.getText().trim().length() < 3) break;
                    if (Integer.parseInt(this.m_TextField.getText()) > 255) {
                        this.m_TextField.setText("255");
                    }
                    this.m_TextField.nextFocus();
                }
            }
        }
    }
}

