/*
 * Decompiled with CFR 0.152.
 */
package UI;

import Function.MainModel;
import Util.ImageButton;
import Util.Log;
import Util.WebAppRes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MainControl
extends JPanel
implements MouseListener {
    private ImageButton btnRefresh;
    private ImageButton btnASet;
    private ImageButton btnMSet;
    private ImageButton btnInfo;
    private ImageButton btnConn;
    private JLabel logo;
    private MainModel model = null;
    private static final int hMargin = 10;
    private static final int lMargin = 11;
    private static final int bMargin = 16;
    private static final int rMargin = 8;

    public MainControl(MainModel mainModel) {
        this.model = mainModel;
        this.setSize(640, 60);
        this.setLayout(null);
        this.setBackground(new Color(247, 247, 247));
        this.CreateControl();
        this.SetPosition();
    }

    private void CreateControl() {
        this.btnRefresh = new ImageButton("refresh_up.jpg", "refresh_down.jpg", "refresh_up.jpg", true);
        this.btnASet = new ImageButton("autoset_up.jpg", "autoset_down.jpg", "autoset_disable.jpg", true);
        this.btnMSet = new ImageButton("manset_up.jpg", "manset_down.jpg");
        this.btnInfo = new ImageButton("about_up.jpg", "about_down.jpg");
        this.btnConn = new ImageButton("EWS_up.jpg", "EWS_down.jpg", "EWS_disable.jpg", true);
        this.btnRefresh.setToolTipText(WebAppRes.GetString("IDS_REFRESH"));
        this.btnASet.setToolTipText(WebAppRes.GetString("IDS_SETUP"));
        this.btnMSet.setToolTipText(WebAppRes.GetString("IDS_MAN_SET"));
        this.btnConn.setToolTipText(WebAppRes.GetString("IDS_LAUNCH"));
        this.btnInfo.setToolTipText(WebAppRes.GetString("IDS_ABOUT"));
        this.add(this.btnRefresh);
        this.add(this.btnASet);
        this.add(this.btnMSet);
        this.add(this.btnInfo);
        this.add(this.btnConn);
        String string = WebAppRes.GetString("IDS_COMPANY_NAME");
        if (string.indexOf("SAMSUNG") > -1) {
            this.logo = new JLabel(WebAppRes.GetImageIcon("logo.jpg"));
            this.add(this.logo);
        }
        this.btnRefresh.setName("Refresh");
        this.btnASet.setName("Auto");
        this.btnMSet.setName("Manual");
        this.btnInfo.setName("Information");
        this.btnConn.setName("Connection");
        this.btnRefresh.addMouseListener(this);
        this.btnASet.addMouseListener(this);
        this.btnMSet.addMouseListener(this);
        this.btnInfo.addMouseListener(this);
        this.btnConn.addMouseListener(this);
    }

    public void reshapeControl() {
        this.btnRefresh.setToolTipText(WebAppRes.GetString("IDS_REFRESH"));
        this.btnASet.setToolTipText(WebAppRes.GetString("IDS_SETUP"));
        this.btnMSet.setToolTipText(WebAppRes.GetString("IDS_MAN_SET"));
        this.btnConn.setToolTipText(WebAppRes.GetString("IDS_LAUNCH"));
        this.btnInfo.setToolTipText(WebAppRes.GetString("IDS_ABOUT"));
    }

    private void SetPosition() {
        int n = 11;
        this.btnRefresh.setBounds(n, 10, this.btnRefresh.getImageWidth(), this.btnRefresh.getImageHeight());
        this.btnASet.setBounds(n += this.btnRefresh.getImageWidth() + 16, 10, this.btnASet.getImageWidth(), this.btnASet.getImageHeight());
        this.btnMSet.setBounds(n += this.btnASet.getImageWidth() + 16, 10, this.btnMSet.getImageWidth(), this.btnMSet.getImageHeight());
        this.btnConn.setBounds(n += this.btnMSet.getImageWidth() + 16, 10, this.btnConn.getImageWidth(), this.btnConn.getImageHeight());
        this.btnInfo.setBounds(n += this.btnMSet.getImageWidth() + 16, 10, this.btnInfo.getImageWidth(), this.btnInfo.getImageHeight());
        n = 528;
        if (this.logo != null) {
            this.logo.setBounds(n, 10, this.logo.getIcon().getIconWidth(), this.logo.getIcon().getIconHeight());
        }
    }

    public void setEnableAutoSetButton(boolean bl) {
        this.btnASet.setEnabled(bl);
        this.btnConn.setEnabled(bl);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object instanceof ImageButton) {
            Component component = (Component)object;
            String string = component.getName();
            Log.write(0, string + " is clicked!");
            if (string.startsWith("Auto")) {
                ImageButton imageButton = (ImageButton)object;
                if (imageButton.enabled) {
                    this.model.loadSetWindow(true);
                }
            } else if (string.startsWith("Manual")) {
                this.model.loadSetWindow(false);
            } else if (string.startsWith("Information")) {
                this.model.loadInfoWindow();
            } else if (string.startsWith("Connection")) {
                this.model.goPrintServer();
            } else if (string.startsWith("Refresh")) {
                ImageButton imageButton = (ImageButton)object;
                if (imageButton.enabled) {
                    this.clickRefresh();
                }
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void clickRefresh() {
        this.btnRefresh.setEnabled(false);
        this.setCursor(new Cursor(3));
        this.model.getPacket();
        this.setCursor(new Cursor(0));
        this.btnRefresh.setEnabled(true);
        this.btnASet.setEnabled(false);
        this.btnConn.setEnabled(false);
    }
}

