/*
 * Decompiled with CFR 0.152.
 */
package Util;

import java.io.CharArrayWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;

public class Log {
    public static final int LOG_DEBUG = 0;
    public static final int LOG_INFO = 1;
    public static final int LOG_WARN = 2;
    public static final int LOG_ERROR = 3;
    private static Log m_gs_instance = null;
    private Writer m_gs_logstream = null;
    private boolean m_gs_bFlush = true;
    private int loglevel = 2;
    private boolean stamp = false;

    Log() {
    }

    public static final Log instance() {
        if (m_gs_instance == null) {
            try {
                m_gs_instance = new Log();
            }
            catch (Exception exception) {
                System.out.println("[error] Log.instance(): Unable to create Log.");
                return null;
            }
        }
        return m_gs_instance;
    }

    public static void startLog(String string) {
        FileWriter fileWriter;
        try {
            fileWriter = new FileWriter(string);
        }
        catch (Exception exception) {
            fileWriter = null;
        }
        Log.startLog(fileWriter);
    }

    public static void startLog(Writer writer) {
        Log.instance().m_gs_logstream = writer;
    }

    public static void write(int n, String string) {
        String string2 = "Log.write: Unrecognized loglevel.";
        try {
            if (n >= Log.instance().loglevel) {
                switch (n) {
                    case 0: {
                        string2 = "[debug] ";
                        break;
                    }
                    case 1: {
                        string2 = "[info] ";
                        break;
                    }
                    case 2: {
                        string2 = "[warn] ";
                        break;
                    }
                    case 3: {
                        string2 = "[error] ";
                    }
                }
                if (Log.instance().stamp) {
                    string2 = string2 + new Date().toString() + " ";
                }
                string2 = string2 + string + "\n";
                Log.write(string2);
                if (Log.instance().m_gs_bFlush) {
                    Log.flush();
                }
            }
        }
        catch (Exception exception) {
            System.out.println("[error] Log.write can't write to logstream: " + exception);
            exception.printStackTrace();
        }
    }

    public static void printStackTrace() {
    }

    public static void logThrowable(int n, Throwable throwable) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        throwable.printStackTrace(new PrintWriter(charArrayWriter));
        Log.write(n, charArrayWriter.toString());
    }

    private static void write(String string) throws IOException {
        if (Log.instance().m_gs_logstream != null) {
            Log.instance().m_gs_logstream.write(string);
        } else {
            System.out.println(string);
        }
    }

    private static void flush() throws IOException {
        if (Log.instance().m_gs_logstream != null) {
            Log.instance().m_gs_logstream.flush();
        }
    }

    public static void stopLog() {
        try {
            if (Log.instance().m_gs_logstream != null) {
                Log.instance().m_gs_logstream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        m_gs_instance = null;
    }

    public static void setFlush(boolean bl) {
        Log.instance().m_gs_bFlush = bl;
    }

    public static void setLogLevel(int n) {
        Log.instance().loglevel = n;
    }

    public static int getLogLevel() {
        return Log.instance().loglevel;
    }

    public static void setStamp(boolean bl) {
        Log.instance().stamp = bl;
    }
}

